# -*- coding: utf-8 -*-

from xbmcgui import Dialog, NOTIFICATION_INFO

from .resources import Resources


class ConfigActions:
    def __init__(self, resources: Resources) -> None:
        self.__dialog = Dialog()
        self.__resources = resources

    def clear_requests_cache(self, provider_id: str) -> None:
        self.__resources.fs().dir_unlink('requests-cache-' + provider_id)
        self.__dialog.notification(
            self.__resources.addon_info('name'),
            self.__resources.translate('REQUESTS_CACHE_CLEARED', 'Requests cache cleared.'),
            NOTIFICATION_INFO,
            5000
        )

    def clear_session(self, provider_id: str) -> None:
        self.__resources.session().clear(provider_id)
        self.__dialog.notification(
            self.__resources.addon_info('name'),
            self.__resources.translate('SESSION_CLEARED', 'Session cleared.'),
            NOTIFICATION_INFO,
            5000
        )

    def open_settings(self) -> None:
        self.__resources.settings().open()
