# -*- coding: utf-8 -*-
from traceback import format_exc
from xbmc import log, LOGINFO, LOGWARNING, LOGERROR
from typing import Union


class Logger:
    def __init__(self, prefix: str) -> None:
        self.__prefix = prefix

    def __format(self, msg_format: Union[str, bytes], *args) -> str:
        args = map(self.__ensure_text, args)
        return self.__prefix + ': ' + self.__ensure_text(msg_format).format(*args)

    def notice(self, msg_format: Union[str, bytes], *args) -> None:
        log(self.__format(msg_format, *args), LOGINFO)

    def warning(self, msg_format: Union[str, bytes], *args) -> None:
        log(self.__format(msg_format, *args), LOGWARNING)

    def error(self, msg_format: Union[str, bytes], *args) -> None:
        log(self.__format(msg_format, *args), LOGERROR)
        log(format_exc(), LOGERROR)

    @staticmethod
    def __ensure_text(s):
        if isinstance(s, bytes):
            return s.decode('ascii', 'xmlcharrefreplace')
        elif isinstance(s, str):
            return s
        else:
            return str(s)
