# -*- coding: utf-8 -*-

from cProfile import Profile
from pstats import Stats

from io import StringIO
from xbmcgui import Dialog, NOTIFICATION_ERROR

from .resources import Resources


class Profiler:
    def __init__(self, name: str, resources: Resources) -> None:
        self.__name = name
        self.__logger = resources.logger()
        self.__resources = resources
        pass

    def __enter__(self) -> None:
        if self.__resources.debug().profiling:
            self.__pr = Profile()
            self.__pr.enable()

    def __exit__(self, *args) -> None:
        if self.__resources.debug().profiling:
            self.__pr.disable()
            s = StringIO()
            ps = Stats(self.__pr, stream=s).sort_stats('time')
            ps.print_stats(10)
            self.__logger.notice('Profiling {0}\n\n{1}', self.__name, s.getvalue())
            Dialog().notification(
                self.__resources.addon_info('name'),
                '{0} executed in {1}'.format(self.__name, ps.total_tt),
                NOTIFICATION_ERROR,
                5000
            )
