# -*- coding: utf-8 -*-
from typing import List, Dict

from .provider import Provider


class Providers:
    __providers: Dict[str, Provider] = {}

    def add_provider(self, provider: Provider) -> None:
        self.__providers[provider.get_id()] = provider

    def get_ids(self) -> List[str]:
        return list(self.__providers.keys())

    def get(self, provider_id: str) -> Provider:
        return self.__providers[provider_id] if provider_id in self.__providers else None

    def count(self) -> int:
        return len(self.get_ids())
