# -*- coding: utf-8 -*-

from .resources import PluginDataDir
from simplejson import load, dump


class SearchStore:
    def __init__(self, provider_id: str, fs: PluginDataDir) -> None:
        self.__fs = fs
        self.__file = 'search-phrases-'+provider_id+'.json'

    def get_all(self) -> list:
        if self.__fs.file_exists(self.__file):
            with open(self.__fs.get_path(self.__file), 'r') as reader:
                json = load(reader)

            phrases = []
            if not isinstance(json, list):
                return phrases

            for phrase in json:
                if not isinstance(phrase, str):
                    continue
                phrases.append(phrase)

            return phrases
        return []

    def save(self, phrase: str) -> None:
        phrases = self.get_all()
        if phrase in phrases:
            return

        phrases.append(phrase)
        self.__save(phrases)

    def delete(self, phrase: str) -> None:
        phrases = self.get_all()
        if phrase not in phrases:
            return

        phrases.remove(phrase)
        self.__save(phrases)

    def replace(self, old_phrase: str, new_phrase: str) -> None:
        phrases = self.get_all()
        if old_phrase in phrases:
            phrases.remove(old_phrase)

        phrases.append(new_phrase)
        self.__save(phrases)

    def __save(self, phrases: list) -> None:
        with open(self.__fs.get_path(self.__file), 'w') as writer:
            dump(phrases, writer)
